#!/bin/bash
##############################################################################
# Title      :  Q-Review - Quick System Review
# Version    :  1.0.2
# Author     :  Robert Hood | Josh Bray | Larry Wilson
# Date       :  2016-06-08
# Last Update:  2016-07-30
# System     :  CentOS
# Category   :  System
# Usage      :  qreview
# Install    :  nano /usr/bin/qreview, 'copy and paste code', chmod +x qreview
##############################################################################
# Description:
# Quick review of CentOS web server (VPS/Dedicated) in an easy to read format.
##############################################################################
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
##############################################################################
# start
    clear
# define options file
    tmpfile=$(mktemp /tmp/qreview.XXXXXX)
# defines colors:
    #txtund=$(tput sgr 0 1)   # Underline
    #txtbld=$(tput bold)      # Bold
    txtred=$(tput setaf 1)    # Red
    txtgrn=$(tput setaf 2)    # Green
    txtylw=$(tput setaf 3)    # Yellow
    txtblu=$(tput setaf 4)    # Blue
    txtpur=$(tput setaf 5)    # Purple
    txtcyn=$(tput setaf 6)    # Cyan
    #Stxtwht=$(tput setaf 7)  # White
    txtrst=$(tput sgr0)       # Text reset
# Create help display
    function display_help
      {
        echo
        echo "QReview: Quick review of CentOS web server (VPS/Dedicated) in an easy to read format."
        echo "USAGE: qreview -options"
        echo "-h | --help        Show usage information and exit"
        echo "-d | --apache      Runs the Apache function"
        echo "-s | --mysql       Runs the MySQL function"
        echo "-r | --resource    Runs the Resources function"
        echo "-m | --malware     Runs the Malware function"
        echo "-n | --network     Runs the Network function"
        echo "-e | --email       Runs the Email function"
        echo "-a | --all         Runs All functions"
      }
# Parse options:
    show_help=0
    option_apache=0
    option_sql=0
    option_resource=0
    option_malware=0
    option_network=0
    option_email=0
    option_all=0
# Parse arguments - short and long options
    for option in "$@"
      do
        case $option in
          -d) option_apache=1;;
          --apache) option_apache=1;;
          -s) option_sql=1;;
          --mysql) option_sql=1;;
          -r)  option_resource=1;;
          --resource) option_resource=1;;
          -m) option_malware=1;;
          --malware) option_malware=1;;
          -n) option_network=1;;
          --network) option_network=1;;
          -e) option_email=1;;
          --email) option_email=1;;
          -a) option_all=1;;
          --all) option_all=1;;
          -h) show_help=1;;
          --help) show_help=1;;
        esac
        if [ "$show_help" -eq 1 ] ;then display_help;exit; fi
        if [ "$option_apache" -eq 1 ] ;then   echo apache >> $tmpfile; fi
        if [ "$option_sql" -eq 1 ] ;then      echo sql >> $tmpfile; fi
        if [ "$option_resource" -eq 1 ] ;then echo resource >> $tmpfile; fi
        if [ "$option_malware" -eq 1 ] ;then  echo malware >> $tmpfile; fi
        if [ "$option_network" -eq 1 ] ;then  echo network >> $tmpfile; fi
        if [ "$option_email" -eq 1 ] ;then    echo email >> $tmpfile; fi
        if [ "$option_all" -eq 1 ] ;then      printf "apache \n sql \n resource \n malware \n network \n email \n" >> $tmpfile; fi
        done
        unset option
# Define Review Log file
    reviewlog=/home/serverreview-$(date +%Y-%m-%d).txt
# Bleachs the Review Log of the color customization
    bleach ()
    {
      sed -ri "s/\x1B\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]//g" $reviewlog
    }
# Defines the Apache check function
    apache ()
    {
      exec > >(tee -ia $reviewlog)
      echo
      T="$(date +%s)"
      echo "${txtred}======================================[ Apache ]========================================${txtrst}"
      echo
      echo "${txtred}Apache Status:${txtrst}"
      service httpd status
      echo
      echo "${txtred}Disk and Inode Space:${txtrst}"
      df -h
      df -i
      echo
      echo "${txtred}Dedrads Check:${txtrst}"
      /opt/dedrads/check_apache --status
      echo
      echo "${txtred}Tail Apache Error Log:${txtrst}"
      tail -25 /usr/local/apache/logs/error_log
      echo
      echo "${txtylw}===End of Report===${txtrst}"
      T="$(($(date +%s)-T))"
      echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
      bleach
      sleep 1s
    }
# Defines the email check funcstion
    email ()
    {
      exec > >(tee -ia $reviewlog)
      echo
      T="$(date +%s)"
      echo "${txtblu}========================================[ EMail ]======================================${txtrst}"
      echo ""
      echo "${txtblu}Exiwhat:${txtrst}"
      exiwhat
      echo
      echo "${txtblu}Count in Queue:${txtrst}"
      exim -bpc
      echo
      echo "${txtblu}Exim Summary:${txtrst}"
      count=$(exim -bpc);
      if (( $count > 32 ));
        then
          echo "Exim Queue exceeds 32 messages and is too large to summarize for a report, if you must review this then manually run exim -bp."
        else
          exim -bp
      fi
      echo
# Clear of Exim Queue
      read -p "${txtblu}Do you wish to clear the Exim queue? [${txtrst}${txtred}y/n${txtrst}${txtblu}]${txtrst}" clear
        if [[ $clear = y ]] ;
         then
           exim -bp | exiqgrep -i | xargs exim -Mrm > /dev/null 2>&1
            echo "The Exim queue has been cleared."
          else
           echo "No? Is that your final answer?"
        fi
      echo
# Display Account/Script Usage
      echo "${txtblu}Unique Emails Sent by:${txtrst}"
      sudo cat /var/log/exim_mainlog | grep "A\=dovecot_login" | awk -F"A=dovecot_login:" {'print $2'} | cut -f1 -d' ' | sort | uniq -c | sort -n | awk {'print $1, "unique emails sent by" , $2'}
      echo
      echo "${txtblu}Location of Scripts Sending Mail:${txtrst}"
      sudo cat /var/log/exim_mainlog | grep cwd | grep -v /var/spool | awk -F"cwd=" '{print $2}' | awk '{print $1}' | sort | uniq -c | sort -n
      echo
      T="$(($(date +%s)-T))"
# Run Logs for Two Accounts
      read -p "${txtylw}Run logs for specific user(s)? [${txtrst}${txtblu}y/n${txtrst}${txtylw}]${txtrst}" answer
        if [[ $answer = y ]] ;
         then
          echo -n "${txtylw}Enter First Address: ${txtrst}"
          read sendaddress
          echo -n "${txtylw}Enter Second Address (if none leave blank): ${txtrst}"
          read recaddress
          echo
          echo "${txtblu}Exim_mainlog Result:${txtrst}"
          sudo cat /var/log/exim_mainlog | grep $sendaddress | grep $recaddress
        fi
      echo
      echo "${txtylw}===End of Report===${txtrst}"
      echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
      bleach
    }
# Defines the network check function
    network ()
    {
      exec > >(tee -ia $reviewlog)
      echo
      T="$(date +%s)"
      echo "${txtpur}=======================================[ Network ]=====================================${txtrst}"
      echo ""
      echo "${txtpur}Top IPs Connecting:${txtrst}"
      /opt/dedrads/check_apache --countip
      echo ""
      echo "${txtpur}Connections:${txtrst}"
      echo
      netstat -plan | awk '/.*[0-9]+.[0-9]+.[0-9]+.[0-9].*/{gsub(/::ffff:/,"",$0);print $4"\t" $5}'|cut -sd. -f 1->netstat.log;echo "${txtpur}Netstat  report${txtrst}";echo;echo  "${txtpur}Number of Connections to each port:${txtrst}";cat netstat.log |awk {'print $1'}|cut -d: -f 2|sort|uniq -c|sort -nk 1|tail;echo;echo  "${txtpur}Number of connections from each IP:${txtrst}";cat netstat.log |awk {'print $2'}|cut -d: -f 1|sort|uniq -c|sort -nk 1|tail;echo;echo "${txtpur}The number of instances of a particular IP connecting to particular port${txtrst}";cat netstat.log |awk {'print $1 "\t" $2'}|cut -d: -f 2|sort|uniq -c|sort -nk 1|tail;
      echo
# Run NLP for User
      read -p "${txtylw}Run NLP for specific user? [${txtrst}${txtpur}y/n${txtrst}${txtylw}]${txtrst}" answer
        if [[ $answer = y ]] ;
          then
            echo -n "${txtylw}Enter Username: ${txtrst}"
            read nlp
            echo "${txtpur}NLP Result:${txtrst}"
            sudo /opt/dedrads/nlp $nlp
        fi
      echo
      echo "${txtylw}===End of Report===${txtrst}"
      T="$(($(date +%s)-T))"
      echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
      bleach
      sleep 1s
    }
# Defines mysql check function
    sql ()
    {
      exec > >(tee -ia $reviewlog)
      echo
      T="$(date +%s)"
      echo "${txtcyn}========================================[ MySQL ]======================================${txtrst}"
      echo ""
      echo "${txtcyn}MySQL Status:${txtrst}"
      echo "MySQL:" `echo "status;" | mysql | grep -i uptime`; mysqladmin status
      echo ""
      echo "${txtcyn}MySQL Connections:${txtrst}"
      /opt/tier2c/check_mysql --sockets
      echo ""
      echo "${txtcyn}Slow Queries:${txtrst}"
      /opt/dedrads/mysql/slowqueryparser.py /var/log/slowqueries
      echo ""
      echo
# Auto Enable or Check Slow Query Logging
      read -p "${txtcyn}Would you like to enable Slow Query Logging? [${txtrst}${txtpur}y/n${txtrst}${txtcyn}]${txtrst}" answer
        if [[ $answer = y ]] ;
          then
            mysqlver=$(mysql --version | awk '{ print $5}' | cut -c-3)
            compare=$(echo "$mysqlver >= 5.6" | bc -l) # Checking to see if the server is MySQL 5.6
              if (( $compare == 1 )); # Confirms 5.6 or greater and runs needed check before code implement.
                then
                  check=$(cat /etc/my.cnf | grep slow_query_log | wc -l)
                    if (( $check > 0));
                      then
                        echo "${txtcyn}Slow Query Logging appears to be enabled or set up previously, please manually review and follow the guide here:${txtrst} ${txtred}http://wiki.inmotionhosting.com/index.php?title=MySql:_my.cnf_settings${txtrst}"
                      else
                        printf '\nslow_query_log = 1\nslow_query_log_file = /var/log/slowqueries\nlong_query_time = 3' >> /etc/my.cnf
                        touch /var/log/slowqueries
                        chown mysql:mysql /var/log/slowqueries
                        chmod 664 /var/log/slowqueries
                        service mysql restart
                        echo "${txtcyn}Slow Query Logging Enabled for MySQL 5.6+.${txtrst}"
                    fi
                  else # Confirms it is not 5.6 or greater and runs check for 5.5 syntax before implementing code.
                    check=$(cat /etc/my.cnf | grep log-slow-queries | wc -l)
                      if (( $check > 0));
                        then
                          echo "${txtcyn}Slow Query Logging appears to be enabled or set up previously, please manually review and follow the guide here:${txtrst} ${txtred}http://wiki.inmotionhosting.com/index.php?title=MySql:_my.cnf_settings${txtrst}"
                        else
                          printf '\nlog-slow-queries = /var/log/slowqueries\nlong_query_time = 3' >> /etc/my.cnf
                          touch /var/log/slowqueries
                          chown mysql:mysql /var/log/slowqueries
                          chmod 664 /var/log/slowqueries
                          service mysql restart
                          echo "{txtcyn}Slow Query Logging Enabled for MySQL 5.5 or lower.${txtrst}"
                      fi
              fi
        fi
      echo "${txtcyn}Queries Running:${txtrst}"
      mysqladmin pr
      echo ""
      echo "${txtcyn}Kernel Panic Log Check for MySQL Errors:${txtrst}"
      dmesg | grep mysql
      echo
      echo "${txtylw}===End of Report===${txtrst}"
      T="$(($(date +%s)-T))"
      echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
      bleach
      sleep 1s
    }
# Defines the Resource check function
    resource ()
      {
        exec > >(tee -ia $reviewlog)
        echo
        T="$(date +%s)"
        echo "${txtgrn}======================================[ Usage ]========================================${txtrst}"
        echo ""
        echo "${txtgrn}Uptime:${txtrst}"
        uptime
        echo ""
        echo "${txtgrn}Last Logins:${txtrst}"
        last -a |head -3
        echo ""
# Display Resource Usage
        echo "${txtgrn}Disk and Memory Usage:${txtrst}"
        df -h | xargs | awk '{print "Free/total disk: " $11 " / " $9}'
        free -m | xargs | awk '{print "Free/total memory: " $17 " / " $8 " MB"}'
        echo ""
        echo "${txtgrn}Power Users:${txtrst}"
        sa -cmi
        echo ""
        echo "${txtgrn}Top Active Processes (TOP):${txtrst}"
        top -n 1
        echo ""
        echo "${txtgrn}System Activity Report (SAR):${txtrst}"
        sar -q
        echo ""
        echo "${txtgrn}Process IDs:${txtrst}"
        pidstat
        echo ""
        echo "${txtgrn}IO Stats:${txtrst}"
        iostat
        echo
        echo "${txtgrn}Check for OOM in Kernel Panic Log:${txtrst}"
        dmesg | grep OOM
        echo
# Run Ps u for User
        read -p "${txtylw}Run PS U for specific user? [${txtrst}${txtgrn}y/n${txtrst}${txtylw}]${txtrst}" answer
          if [[ $answer = y ]] ;
            then
              echo -n "${txtylw}Enter Username: ${txtrst}"
              read psu
              echo "${txtgrn}PS U Result:${txtrst}"
              sudo ps u -u $psu
          fi
        echo
        echo "${txtylw}===End of Report===${txtrst}"
        T="$(($(date +%s)-T))"
        echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
        bleach
        sleep 1s
      }
# Defines the malware check function
    malware ()
      {
        exec > >(tee -ia $reviewlog)
        echo
        T="$(date +%s)"
        echo "${txtred}========================================[ Malware ]======================================${txtrst}"
        echo
        echo "${txtred}Dedrads Hack Check:${txtrst}"
        /opt/dedrads/check_hacks
        echo
        read -p "${txtred}Do you want to run a Shellscan? [${txtrst}${txtylw}Y/N${txtrst}${txtred}] ${txtrst}" malware
          if [ "$malware" == y ] || [ "$malware" == Y ];
            then
              echo "Installing Shellscan."
              yum -y install imh-shellscan > /dev/null 2>&1
              echo "Warning! This scan does not quarantine any files, this is only a scan."
              echo "Warning! This scan starts a shellscan in screen, however the screen will not show the results, you will need to check the given filename."
              read -p "${txtred}Do you want to run a Shellscan for all users or one user? [${txtrst}${txtylw}A${txtrst}${txtred}]ll/[${txtrst}${txtylw}O${txtrst}${txtred}]ne:${txtrst} " scan
                if [ "$scan" == a ] || [ "$scan" == A ];
                  then
                    echo "Scan running for all users in /var/cpanel/users. Please check /home/shellscan-$(date +%d%^b%y).txt for the results."
                    screen -dmS scanspawn sleep 30
                    screen -S scanspawn -X screen screen -dR shellscan
                    sleep 1
                    screen -S shellscan -X detach
                    screen -S shellscan -X stuff "shellscan --update --freshclam -n -u $(ls /var/cpanel/users | tr "\n" " ") >> /home/shellscan-$(date +%d%^b%y).txt; echo 'The shellscan on $(hostname) has completed.' $(echo -ne '\015')"
                fi
                if [ "$scan" == o ] || [ "$scan" == O ];
                  then
                    echo "${txtred}Current users on the server: ${txtrst}"
                    ls /var/cpanel/users | sort
                    read -p "${txtred}What user do you wish to run a shellscan for?${txtrst} " user
                    echo "Scan running for $user. Please check /home/$user-shellscan-$(date +%d%^b%y).txt for the results."
                    screen -dmS scanspawn sleep 30
                    screen -S scanspawn -X screen screen -dR $user
                    sleep 1
                    screen -S $user -X detach
                    screen -S $user -X stuff "shellscan --update --freshclam -n -u $user >> /home/$user-shellscan-$(date +%d%^b%y).txt; echo 'The shellscan on $(hostname) has completed.' $(echo -ne '\015')"
                fi
          fi
          if [ "$malware" == n ] || [ "$malware" == N ];
            then
              echo “For a moment, nothing happened. Then, after a second or so, nothing continued to happen.”
          fi
        echo
        echo "${txtylw}===End of Report===${txtrst}"
        echo "${txtylw}Review took ${T} seconds to process.${txtrst}"
        bleach
        sleep 1s
      }
# Define Menu
    menu ()
      {
        touch $reviewlog
        whiptail --separate-output --checklist "QReview Modules" 20 40 8\
          "apache" "Run Apache Module" ON \
          "sql" "Run MySQL Module" OFF \
          "resource" "Run Resources Module" OFF \
          "malware" "Run Malware Module" OFF \
          "network" "Run Network Module" OFF \
          "email" "Run Email Module" OFF 2>$tmpfile
      }
# Check to see if menu function should run.
# Generates the log if $tmpfile is not empty , else runs menu for what to log.
      if [ -s $tmpfile ]; then touch $reviewlog; else menu; fi
      for x in $(cat $tmpfile); do $x; done
      echo "${txtylw}The report has been placed at ${reviewlog} ${txtrst}"

