#!/usr/bin/env bash

####################################################################
# BLACKLIST CHECK UTILITY                                          #
# copyright: Who needs that?                                       #
# author: Ryan Co                                                  #
# license: GNU                                                     #
# description: Simple Blacklist utility because I was bored        #
####################################################################

#### main ####
main() {

  [ $# -ne 1 ] && error "Please specify a FQDN or IP as a parameter."

  fqdn=$(echo $1 | grep -P "(?=^.{5,254}$)(^(?:(?!\d+\.)[a-za-z0-9_\-]{1,63}\.?)+(?:[a-za-z]{2,})$)")

  if [[ $fqdn ]] ; then

    echo "You entered a domain: $1"

    domain=$(host $1 | head -n1 | awk '{print $4}')

    reverseit $domain "IP not valid or domain could not be resolved."
  else

    echo "You entered an IP: $1"
    reverseit $1 "IP not valid."
  fi

  loopthroughblacklists $1
}

#### Get your reverse on ####
reverseit() {

  reverse=$(echo $1 |
  sed -ne "s~^\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)$~\4.\3.\2.\1~p")

  if [ "x${reverse}" = "x" ] ; then

    error $2 
    exit 1
  fi
}

#### Blacklist Loop ####
loopthroughblacklists() {

  reverse_dns=$(dig +short -x $1)

  echo $1 name ${reverse_dns:----}

  for bl in ${blacklists} ; do

      printf $(env tz=utc date "+%y-%m-%d_%h:%m:%s_%z")
      printf "%-40s" " ${reverse}.${bl}."

      listed="$(dig +short -t a ${reverse}.${bl}.)"

      if [[ $listed ]]; then

        if [[ $listed == *"timed out"* ]]; then

          echo "[timed out]" | cecho YELLOW 
        else
        
          echo "[blacklisted] (${listed})" | cecho LRED
        fi
      else

          echo "[not listed]" | cecho LGREEN
      fi
  done
}

#### error ####
error() {

  echo $0 error: $1 >&2
  exit 2
}

#### Cecho ####
cecho(){
  LGREEN="\033[1;32m"
  LRED="\033[1;31m"
  YELLOW="\033[1;33m"
  NORMAL="\033[m"
 
  color=\$${1:-NORMAL}
 
  echo -ne "$(eval echo ${color})"
  cat
 
  echo -ne "${NORMAL}"
}

#### Blacklists ####
blacklists="
0spamurl.fusionzero.com
    csi.cloudmark.com
  _vouch.dwl.spamhaus.org
  abuse.rfc-clueless.org
  badconf.rhsbl.sorbs.net
  black.uribl.com
  bogusmx.rfc-clueless.org
  bsb.empty.us
  bsb.spamlookup.net
  dbl.spamhaus.org
  dnsbl.aspnet.hu
  dnsbl.othello.ch
  dob.sibl.support-intelligence.net
  dsn.rfc-clueless.org
  dyndns.rbl.jp
  elitist.rfc-clueless.org
  ex.dnsbl.org
  fresh.spameatingmonkey.net
  fresh10.spameatingmonkey.net
  fresh15.spameatingmonkey.net
  fulldom.rfc-clueless.org
  grey.uribl.com
  hostkarma.junkemailfilter.com
  iddb.isipp.com
  in.dnsbl.org
  l1.apews.org
  list.anonwhois.net
  multi.surbl.org
  multi.uribl.com
  nobl.junkemailfilter.com
  nomail.rhsbl.sorbs.net
  postmaster.rfc-clueless.org
  red.uribl.com
  reputation-domain.rbl.scrolloutf1.com
  reputation-ns.rbl.scrolloutf1.com
  rhsbl.rymsho.ru
  rhsbl.scientificspam.net
  rhsbl.sorbs.net
  rhsbl.zapbl.net
  ubl.nszones.com
  uri.blacklist.woody.ch
  uribl.abuse.ro
  uribl.pofon.foobar.hu
  uribl.spameatingmonkey.net
  uribl.swinog.ch
  uribl.zeustracker.abuse.ch
  urired.spameatingmonkey.net
  url.rbl.jp
  white.uribl.com
  whois.rfc-clueless.org
access.redhawk.org
all.spamblock.unit.liu.se
b.barracudacentral.org
bl.deadbeef.com
bl.emailbasura.org
bl.spamcannibal.org
bl.spamcop.net
black.uribl.com
blackholes.five-ten-sg.com
blackholes.mail-abuse.org
blacklist.sci.kun.nl
blacklist.woody.ch
bogons.cymru.com
bsb.spamlookup.net
cbl.abuseat.org
cbl.anti-spam.org.cn
cblless.anti-spam.org.cn
cblplus.anti-spam.org.cn
cdl.anti-spam.org.cn
combined.njabl.org
combined.rbl.msrbl.net
db.wpbl.info
dialups.mail-abuse.org
dnsbl-1.uceprotect.ne
dnsbl-2.uceprotect.net
dnsbl-3.uceprotect.ne
dnsbl.abuse.ch
dnsbl.dronebl.org
dnsbl.inps.de
dnsbl.kempt.net
dnsbl.njabl.org
dnsbl.sorbs.net
dob.sibl.support-intelligence.net
drone.abuse.ch
dsn.rfc-ignorant.org
dsn.rfc-ignorant.org
duinv.aupads.org
dul.blackhole.cantv.net
dul.dnsbl.sorbs.net
dul.ru
dyna.spamrats.com
dynablock.sorbs.net
dyndns.rbl.jp
dynip.rothen.com
forbidden.icm.edu.pl
http.dnsbl.sorbs.net
httpbl.abuse.ch
images.rbl.msrbl.net
ips.backscatterer.org
ix.dnsbl.manitu.net
korea.services.net
ksi.dnsbl.net.au
mail.people.it
misc.dnsbl.sorbs.net
multi.surbl.org
multi.uribl.com
netblock.pedantic.org
noptr.spamrats.com
omrs.dnsbl.net.au
opm.tornevall.org
orvedb.aupads.org
osrs.dnsbl.net.au
pbl.spamhaus.org
phishing.rbl.msrbl.net
probes.dnsbl.net.au
psbl.surriel.com
query.senderbase.org
rbl-plus.mail-abuse.org
rbl.efnetrbl.org
rbl.interserver.net
rbl.spamlab.com
rbl.suresupport.com
rdts.dnsbl.net.au
relays.bl.gweep.ca
relays.bl.kundenserver.de
relays.mail-abuse.org
relays.nether.net
residential.block.transip.nl
ricn.dnsbl.net.au
rmst.dnsbl.net.au
rot.blackhole.cantv.net
sbl.spamhaus.org
short.rbl.jp
smtp.dnsbl.sorbs.net
socks.dnsbl.sorbs.net
sorbs.dnsbl.net.au
spam.dnsbl.sorbs.net
spam.rbl.msrbl.net
spam.spamrats.com
spamguard.leadmon.net
spamlist.or.kr
spamrbl.imp.ch
tor.dan.me.uk
ubl.lashback.com
ubl.unsubscore.com
uribl.swinog.ch
url.rbl.jp
virbl.bit.nl
virus.rbl.jp
virus.rbl.msrbl.net
web.dnsbl.sorbs.net
wormrbl.imp.ch
xbl.spamhaus.org
zen.spamhaus.org
zombie.dnsbl.sorbs.net

"

### Do the things ###
main $1