import os
import time



class Counter():
    '''
    Defines functions used by timer.py and counter.py
    '''
    def clear(self):
        #clears the terminal based on OS
        if os.name == 'nt':
            os.system('cls')
        else:
            os.system('clear')

    def __init__(self):
        # defines CPH counter base var
        self.c = 0
    
    def increase(self):
        # increases, calculates CPH and prints
        self.clear()
        self.c += 1
        self.calc_cph()
        print("Contacts: %d" % (self.c))
        print("CPH: %s" % (self.cph))

    def decrease(self):
        # decreases, calculates CPH and prints
        self.clear()
        self.c -= 1
        self.calc_cph()
        print("Contacts: %d" % (self.c))
        print("CPH: %s" % (self.cph))

    def refresh(self):
        # calculates and prints CPH, used with time.sleep() as refresh
        self.clear()
        self.calc_cph()
        print("Contacts: %d" % (self.c))
        print("CPH: %s" % (self.cph))

    def run_timer(self):
        # adds +1 to minute counter every 60 seconds and outputs to file
        self.minutes = 0
        while True:           
            time.sleep(60)
            self.minutes += 1
            self.f = open( 'minutes.txt', 'w+' )
            self.f.write(str(self.minutes))
            self.f.close()

    def clear_timer(self):
        # used in timer start script to clear away old numbers
        self.f = open( 'minutes.txt', 'w+' )
        self.f.write("1")
        self.f.close()

    def calc_cph(self):
        # reads current minutes, converts to hours and averages CPH
        self.r = open( 'minutes.txt', 'r')
        if self.r.mode == 'r':
            self.contents = self.r.read()
            self.r.close()
        self.hour = float(self.contents) / 60
        self.cph = round(self.c / self.hour,1)
